//   ===============================================================================================
//   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -------------------------------------------------------------------------------------------------
//   Copyright (c) 2021 by Lattice Semiconductor Corporation
// -------------------------------------------------------------------------------------------------
//
// Permission:
//
//   Lattice Semiconductor grants permission to use this code for use in synthesis for any Lattice 
//   programmable logic product.  Other use of this code, including the selling or duplication of 
//   any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL or Verilog source code is intended as a design reference which illustrates how these
//   types of functions can be implemented.  It is the user's responsibility to verify their design
//   for consistency and functionality through the use of formal verification methods.  Lattice 
//   Semiconductor provides no warranty regarding the use or functionality of this code.
//
// -------------------------------------------------------------------------------------------------
//
//                               Lattice Semiconductor Corporation
//                               5555 NE Moore Court
//                               Hillsboro, OR 97214
//                               U.S.A
//                            
//                               TEL: 1-800-Lattice (USA and Canada)
//                                    408-826-6000 (other locations)
//                            
//                               web: http://www.latticesemi.com/
//                               email: techsupport@latticesemi.com
//
// -------------------------------------------------------------------------------------------------
// Filename        : count32.v
// Description     : 32 bit up/down counter
// Created On      : 2021
// Revision        : Revision: 1.00 
// ------------------------------------------------------------------------------------------------

`timescale 1 ns / 1 ps

module count32 (	
  input 			clk,
  input				direction,
  input				reset,
  input				lock,
  output  [31:0]	count
  );
				
  reg [31:0] countai; 
  assign count = countai;

  always@(posedge clk or negedge reset)
  begin 
	if(!reset) begin
		countai <= 32'b0;
	end
	else begin
		if (lock) begin
			if(direction) begin 
				countai <= countai + 1'b1;
				if(countai== 'd50) countai <= 32'b0;
			end			
			else begin
				countai <= countai - 1'b1; 
				if(countai== 32'b0) countai <= 'd50;
			end
		end
		else countai <= 32'b0;
		
	end
  end
 endmodule 
